/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.BasePart;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.StringVar;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class EffectPart
extends BasePart {
    private IntVar radius = new IntVar(1);
    private final StringVar id;
    private final IntVar duration;
    private final IntVar amplifier;

    public EffectPart(MobEffect effect, int duration, int amplifier) {
        this(effect, new IntVar(duration), new IntVar(amplifier));
    }

    public EffectPart(MobEffect effect, IntVar duration, IntVar amplifier) {
        this(new StringVar(String.valueOf(ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)effect))), duration, amplifier);
    }

    public EffectPart(String id, int duration, int amplifier) {
        this(new StringVar(id), new IntVar(duration), new IntVar(amplifier));
    }

    public EffectPart(StringVar id, IntVar duration, IntVar amplifier) {
        this.id = id;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public IntVar getRadius() {
        return this.radius;
    }

    public EffectPart setRadius(int radius) {
        return this.setRadius(new IntVar(radius));
    }

    public EffectPart setRadius(IntVar radius) {
        this.radius = radius;
        return this;
    }

    public MobEffectInstance getEffect() {
        String val = this.id.getValue();
        MobEffect pot = IntVar.isInteger(val) ? MobEffect.m_19453_((int)Integer.parseInt(val)) : (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(val));
        if (pot == null) {
            pot = MobEffects.f_19610_;
            CCubesCore.logger.log(Level.ERROR, "The Potion Effect with the id of " + val + " does not exist! Falling back to default to avoid crash!");
        }
        return new MobEffectInstance(pot, this.duration.getIntValue() * 20, this.amplifier.getIntValue());
    }
}

